<tr class="product_row">
    <td>
        {{$product->product_name}}
        <br/>
        {{$product->sub_sku}}

        @if( session()->get('business.enable_lot_number') == 1 || session()->get('business.enable_product_expiry') == 1)
        @php
            $lot_enabled = session()->get('business.enable_lot_number');
            $exp_enabled = session()->get('business.enable_product_expiry');
            $lot_no_line_id = '';
            if(!empty($product->lot_no_line_id)){
                $lot_no_line_id = $product->lot_no_line_id;
            }
        @endphp

        @if($product->enable_stock == 1)
            <br>
            <small class="text-muted" style="white-space: nowrap;">@lang('report.current_stock'): <span class="qty_available_text">{{$product->formatted_qty_available}}</span> {{ $product->unit }}</small>
        @endif
        @if(!empty($product->lot_numbers))
            <select class="form-control lot_number" name="products[{{$row_index}}][lot_no_line_id]">
                <option value="">@lang('lang_v1.lot_n_expiry')</option>
                @foreach($product->lot_numbers as $lot_number)
                    @php
                        $selected = "";
                        if($lot_number->purchase_line_id == $lot_no_line_id){
                            $selected = "selected";

                            $max_qty_rule = $lot_number->qty_available;
                            $max_qty_msg = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_number->qty_formated, 'unit' => $product->unit  ]);
                        }

                        $expiry_text = '';
                        if($exp_enabled == 1 && !empty($lot_number->exp_date)){
                            if( \Carbon::now()->gt(\Carbon::createFromFormat('Y-m-d', $lot_number->exp_date)) ){
                                $expiry_text = '(' . __('report.expired') . ')';
                            }
                        }
                    @endphp
                    <option value="{{$lot_number->purchase_line_id}}" data-qty_available="{{$lot_number->qty_available}}" data-msg-max="@lang('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_number->qty_formated, 'unit' => $product->unit  ])" {{$selected}}>@if(!empty($lot_number->lot_number) && $lot_enabled == 1){{$lot_number->lot_number}} @endif @if($lot_enabled == 1 && $exp_enabled == 1) - @endif @if($exp_enabled == 1 && !empty($lot_number->exp_date)) @lang('product.exp_date'): {{@format_date($lot_number->exp_date)}} @endif {{$expiry_text}}</option>
                @endforeach
            </select>
        @endif
    @endif
    </td>
    <td>
        <input type="text" name="products[{{$row_index}}][current_stock]" id="current_stock" class="form-control input_number" value="{{@num_format($product->qty_available)}}">
    </td>
    <td>
        <input type="text" class="form-control input_number counted_stock" name="products[{{$row_index}}][counted_stock]" id="counted_stock">
    </td>
    <td>
        {{-- If edit then transaction sell lines will be present --}}
        @if(!empty($product->transaction_sell_lines_id))
            <input type="hidden" name="products[{{$row_index}}][transaction_sell_lines_id]" class="form-control" value="{{$product->transaction_sell_lines_id}}">
        @endif

        <input type="hidden" name="products[{{$row_index}}][product_id]" class="form-control product_id" value="{{$product->product_id}}">

        <input type="hidden" value="{{$product->variation_id}}" 
            name="products[{{$row_index}}][variation_id]">

        <input type="hidden" value="{{$product->enable_stock}}" 
            name="products[{{$row_index}}][enable_stock]">
        
        @if(empty($product->quantity_ordered))
            @php
                $product->quantity_ordered = 1;
            @endphp
        @endif

        <input type="text" class="form-control product_quantity input_number" value="{{@format_quantity($product->quantity_ordered)}}" name="products[{{$row_index}}][quantity]" 
        @if($product->unit_allow_decimal == 1) data-decimal=1 @else data-rule-abs_digit="true" data-msg-abs_digit="@lang('lang_v1.decimal_value_not_allowed')" data-decimal=0 @endif
        data-rule-required="true" data-msg-required="@lang('validation.custom-messages.this_field_is_required')" @if($product->enable_stock) data-rule-max-value="{{$product->qty_available}}" data-msg-max-value="@lang('validation.custom-messages.quantity_not_available', ['qty'=> $product->formatted_qty_available, 'unit' => $product->unit  ])"
        data-qty_available="{{$product->qty_available}}" 
        data-msg_max_default="@lang('validation.custom-messages.quantity_not_available', ['qty'=> $product->formatted_qty_available, 'unit' => $product->unit  ])"
         @endif >
        {{$product->unit}}
    </td>
    <td class="show_price_with_permission">
        <input type="text" name="products[{{$row_index}}][unit_price]" class="form-control product_unit_price input_number" value="{{@num_format($product->default_sell_price)}}">
    </td>
    <td class="show_price_with_permission">
        <input type="text" readonly name="products[{{$row_index}}][price]" class="form-control product_line_total" value="{{@num_format($product->quantity_ordered*$product->default_sell_price)}}">
    </td>
    <td class="text-center">
        <i class="fa fa-trash remove_product_row cursor-pointer" aria-hidden="true"></i>
    </td>
</tr>
<script>
    $(document).ready(function() {
        $(".product_row").each(function() {
            let row = $(this);
            let currentStockInput = row.find("#current_stock");
            let countedStockInput = row.find("#counted_stock");
            let quantityInput = row.find(".product_quantity");
    
            // Make current_stock and quantity read-only
            currentStockInput.prop("readonly", true);
            quantityInput.prop("readonly", true); 
    
            // Update quantity when counted_stock changes
            countedStockInput.on("change", function() {
                let currentStock = Number(currentStockInput.val().replace(/,/g, '')) || 0;
                let countedStock = Number(countedStockInput.val().replace(/,/g, '')) || 0;
                let difference = currentStock - countedStock;
                quantityInput.val(difference);
    
                // Update the row and total when counted stock changes
                update_table_row(row);
            });
        });
    });
    
    // Function to update the total of all table rows
    function update_table_total() {
        var table_total = 0;
        
        $('table#stock_adjustment_product_table tbody tr').each(function() {
            var this_total = parseFloat(__read_number($(this).find('input.product_line_total'))) || 0;
            table_total += this_total;
        });
    
        $('input#total_amount').val(__number_f(table_total)); // Update total amount input
        $('span#total_adjustment').text(__number_f(table_total)); // Display total adjustment
    }
    
    // Function to update a single row
    function update_table_row(tr) {
        var quantity = parseFloat(__read_number(tr.find('input.product_quantity'))) || 0;
        var unit_price = parseFloat(__read_number(tr.find('input.product_unit_price'))) || 0;
        var row_total = quantity * unit_price; // Calculate row total
    
        tr.find('input.product_line_total').val(__number_f(row_total)); // Update row total
    
        update_table_total(); // Update table total
    }
    
    // Attach event listener to update row calculations when counted_stock or unit_price changes
    $(document).on('change', 'input.counted_stock, input.product_unit_price', function() {
        var tr = $(this).closest('tr'); // Get the row of the changed input
        update_table_row(tr); // Recalculate the row
    });

</script>
