<?php

namespace App\Http\Controllers;

use App\MpesaC2BPayment;
use Illuminate\Http\Request;
use App\User;
use Datatables;
use DB;

class MpesaReportController extends Controller
{
    public function mpesaReport()
    {
        $business_id = request()->session()->get('user.business_id');

        $transactions = MpesaC2BPayment::latest()->get();


        return Datatables::of($transactions)
            ->editColumn('created_at', '{{@format_datetime($created_at)}}')


            ->make(true);


        $users = User::allUsersDropdown($business_id, false);

        return view('report.mpesa')->with(compact('users', 'transactions'));
    }
}
